﻿<%@ WebHandler Language="C#" Class="Handler" %>

using System;
using System.Web;
using System.Web.SessionState;
using Chukeh;

public class Handler : IHttpHandler, IRequiresSessionState
{
    public void ProcessRequest(HttpContext Context)
    {
        Context.Response.CacheControl = "no-cache";
        Context.Response.ContentType = "text/plain";
        switch (Context.Request.Params["Command"])
        {
            case "Start":
                Context.Response.CacheControl = "no-cache";
                Chukeh.Data.IResult _StartResult = CThread.Start("Thread", ThreadStart);
                Context.Response.Write(_StartResult.Message);
                break;
            case "Status":
                switch (CThread.State)
                {
                    case CThread.CThreadState.None:
                        Context.Response.Write(CThread.Status + "[没有线程]");
                        break;
                    case CThread.CThreadState.Running:
                        Context.Response.Write(CThread.Status + "[运行中]");
                        break;
                    case CThread.CThreadState.Stoped:
                        Context.Response.Write(CThread.Status + "[已终止]");
                        break;
                    default:
                        Context.Response.Write(CThread.Status + "[未知状态]");
                        break;
                }
                break;
            case "Abort":
                Chukeh.Data.IResult _AbortResult = CThread.Abort();
                Context.Response.Write(_AbortResult.Message);
                CThread.Status = "强行终止";
                break;
            default:
                break;
        }
    }
    
    public void ThreadStart()
    {
        try
        {
            CThread.Impersonate();
            for (int i = 0; i < 120; i++)
            {
                CThread.Status = i.ToString();
                CThread.Sleep(1000);
            }
        }
        catch
        {
            CThread.Status = "发生错误";
        }
    }
    public bool IsReusable {
        get {
            return false;
        }
    }

}